unit CommonXML;

{
  Common constants for generating XML from the movie-watchers database.

  Copyright  Keith Wood (kbwood@iprimus.com.au)
  Written 1 October, 2000.
}

interface

uses
  SysUtils;

resourcestring
  { XML tags and formats }
  CinemaId        = 'cinema-id';
  CinemasTag      = 'cinemas';
  CinemaTag       = 'cinema';
  FacilitiesTag   = 'facilities';
  FeaturesTag     = 'features';
  Id              = 'id';
  MovieId         = 'movie-id';
  MoviesTag       = 'movies';
  MovieTag        = 'movie';
  MovieWatcherTag = 'movie-watcher';
  PriceTag        = 'prices';
  PricingId       = 'pricing-id';
  PricingTag      = 'pricing';
  Rating          = 'rating';
  RestrictionsTag = 'restrictions';
  ScreeningsTag   = 'screenings';
  ScreeningTag    = 'screening';
  SessionsTag     = 'sessions';
  SessionTag      = 'session';
  StarringTag     = 'starring';
  { Field names }
  AddressField    = 'address';
  AdultField      = 'adult';
  CandyBarField   = 'candy_bar';
  ChildField      = 'child';
  CinemaIdField   = 'cinema_id';
  DigSoundField   = 'digital_sound';
  DirectionsField = 'directions';
  DirectorField   = 'director';
  DisabledField   = 'disabled_access';
  DiscountField   = 'discount';
  EndDateField    = 'end_date';
  LengthField     = 'length_mins';
  LogoURLField    = 'logo_url';
  MovieIdField    = 'movie_id';
  NameField       = 'name';
  NoPassesField   = 'no_passes';
  PeriodField     = 'period';
  PhoneField      = 'phone';
  PricingIdField  = 'pricing_id';
  RatingField     = 'rating';
  StarField       = 'star';
  StartDateField  = 'start_date';
  SynopsisField   = 'synopsis';
  TimeField       = 'time';
  URLField        = 'url';
  { XML prolog }
  XMLDTDFile      = 'movie-watcher.dtd';
  XMLComment      = ' Sample XML document with data about movies'#13 +
                    'and when and where they are showing'#13 +
                    'Developed by Keith Wood, 28 May 1999 ';
  XMLPrologAttrs  = 'version="1.0" encoding="UTF-8"';
  XMLStyleAttrs   = 'type="text/xsl" href="movie-watcher.xsl"';
  XMLStyleTag     = 'xml:stylesheet';
  XMLTag          = 'xml';
  { Notations and entities }
  GIFPubId        = '';
  GIFSysId        = 'iview.exe';
  GIFType         = 'GIF';
  HTMLPubId       = '-//W3C//DTD HTML 4.0 Transitional//EN';
  HTMLSysId       = '';
  HTMLType        = 'HTML';

{ Convert field names to XML names }
function ModifyName(Name: string): string;

implementation

{$IFDEF VER100}  { Delphi 3 }
type
  TReplaceFlags = set of (rfReplaceAll, rfIgnoreCase);

function StringReplace(const Value, OldPattern, NewPattern: string;
  Flags: TReplaceFlags): string;
var
  Index: Integer;
begin
  Result := Value;
  Index  := Pos(OldPattern, Result);
  while (Index > 0) do
  begin
    Delete(Result, Index, Length(OldPattern));
    Insert(NewPattern, Result, Index);
    if not (rfReplaceAll in Flags) then
      Break;
    Index := Pos(OldPattern, Result);
  end;
end;
{$ENDIF}

{ Convert field names to XML names }
function ModifyName(Name: string): string;
begin
  Result := LowerCase(StringReplace(Name, '_', '-', [rfReplaceAll]));
end;

end.
